% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkNumber.r
\name{checkNumber}
\alias{assertNumber}
\alias{assert_number}
\alias{checkNumber}
\alias{expect_number}
\alias{testNumber}
\alias{test_number}
\title{Check if an argument is a single numeric value}
\usage{
checkNumber(x, na.ok = FALSE, lower = -Inf, upper = Inf, finite = FALSE)

assertNumber(x, na.ok = FALSE, lower = -Inf, upper = Inf,
  finite = FALSE, add = NULL, .var.name = NULL)

assert_number(x, na.ok = FALSE, lower = -Inf, upper = Inf,
  finite = FALSE, add = NULL, .var.name = NULL)

testNumber(x, na.ok = FALSE, lower = -Inf, upper = Inf, finite = FALSE)

test_number(x, na.ok = FALSE, lower = -Inf, upper = Inf, finite = FALSE)

expect_number(x, na.ok = FALSE, lower = -Inf, upper = Inf,
  finite = FALSE, info = NULL, label = NULL)
}
\arguments{
\item{x}{[any]\cr
Object to check.}

\item{na.ok}{[\code{logical(1)}]\cr
Are missing values allowed? Default is \code{FALSE}.}

\item{lower}{[\code{numeric(1)}]\cr
Lower value all elements of \code{x} must be greater than.}

\item{upper}{[\code{numeric(1)}]\cr
Upper value all elements of \code{x} must be lower than.}

\item{finite}{[\code{logical(1)}]\cr
Check for only finite values? Default is \code{FALSE}.}

\item{add}{[\code{AssertCollection}]\cr
Collection to store assertions. See \code{\link{AssertCollection}}.}

\item{.var.name}{[\code{NULL} || \code{character(1)}]\cr
Name of the checked object to print in error message. If \code{NULL},
the name will be heuristically determined via \code{\link[base]{substitute}}.}

\item{info}{[character(1)]\cr
Extra information to be included in the message for the testthat reporter.
See \code{\link[testthat]{expect_that}}.}

\item{label}{[character(1)]\cr
Same as \code{.var.name}, but passed down to \code{\link[testthat]{expect_that}}.}
}
\value{
Depending on the function prefix:
 If the check is successful, the functions return \code{TRUE}. If the check
 is not successful, \code{assertNumber}/\code{assert_number}
 throws an error message, \code{testNumber}/\code{test_number}
 returns \code{FALSE},
 and \code{checkNumber} returns a string with the error message.
 The function \code{expect_number} always returns an
 \code{\link[testthat]{expectation}}.
}
\description{
Check if an argument is a single numeric value
}
\details{
This function does not distinguish between
\code{NA}, \code{NA_integer_}, \code{NA_real_}, \code{NA_complex_}
\code{NA_character_} and \code{NaN}.
}
\examples{
testNumber(1)
testNumber(1:2)
}
\seealso{
Other scalars: \code{\link{checkCount}},
  \code{\link{checkFlag}}, \code{\link{checkInt}},
  \code{\link{checkScalarNA}}, \code{\link{checkScalar}},
  \code{\link{checkString}}
}

