% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/checkEnvironment.r
\name{checkEnvironment}
\alias{assertEnvironment}
\alias{checkEnvironment}
\alias{expect_environment}
\alias{testEnvironment}
\title{Check if an argument is an environment}
\usage{
checkEnvironment(x, contains = character(0L))

assertEnvironment(x, contains = character(0L), add = NULL, .var.name)

testEnvironment(x, contains = character(0L))

expect_environment(x, contains = character(0L), info = NULL, label = NULL)
}
\arguments{
\item{x}{[any]\cr
Object to check.}

\item{contains}{[\code{character}]\cr
Vector of object names expected in the environment.
Defaults to \code{character(0)}.}

\item{add}{[\code{AssertCollection}]\cr
Collection to store assertions. See \code{\link{AssertCollection}}.}

\item{.var.name}{[character(1)]\cr
Name for \code{x}. Defaults to a heuristic to determine
the name using \code{\link[base]{deparse}} and \code{\link[base]{substitute}}.}

\item{info}{[character(1)]\cr
Extra information to be included in the message for the testthat reporter.
See \code{\link[testthat]{expect_that}}.}

\item{label}{[character(1)]\cr
Same as \code{.var.name}, but passed down to \code{\link[testthat]{expect_that}}.}
}
\value{
Depending on the function prefix:
 If the check is successful, all functions return \code{TRUE}.
 If the check is not successful, \code{assertEnvironment} throws an error message,
 \code{testEnvironment} returns \code{FALSE}, \code{checkEnvironment} returns
 a string with the error message. The function \code{expect_environment} will
 return an \code{\link[testthat]{expectation}}.
}
\description{
Check if an argument is an environment
}
\examples{
ee = as.environment(list(a = 1))
testEnvironment(ee)
testEnvironment(ee, contains = "a")
}
\seealso{
Other basetypes: \code{\link{assertArray}},
  \code{\link{checkArray}}, \code{\link{expect_array}},
  \code{\link{testArray}};
  \code{\link{assertAtomicVector}},
  \code{\link{checkAtomicVector}},
  \code{\link{expect_atomic_vector}},
  \code{\link{testAtomicVector}};
  \code{\link{assertAtomic}}, \code{\link{checkAtomic}},
  \code{\link{expect_atomic}}, \code{\link{testAtomic}};
  \code{\link{assertCharacter}},
  \code{\link{checkCharacter}},
  \code{\link{expect_character}},
  \code{\link{testCharacter}}; \code{\link{assertComplex}},
  \code{\link{checkComplex}}, \code{\link{expect_complex}},
  \code{\link{testComplex}}; \code{\link{assertDataFrame}},
  \code{\link{checkDataFrame}},
  \code{\link{expect_data_frame}},
  \code{\link{testDataFrame}}; \code{\link{assertFactor}},
  \code{\link{checkFactor}}, \code{\link{expect_factor}},
  \code{\link{testFactor}}; \code{\link{assertFunction}},
  \code{\link{checkFunction}},
  \code{\link{expect_function}},
  \code{\link{testFunction}};
  \code{\link{assertIntegerish}},
  \code{\link{checkIntegerish}},
  \code{\link{expect_integerish}},
  \code{\link{testIntegerish}};
  \code{\link{assertInteger}}, \code{\link{checkInteger}},
  \code{\link{expect_integer}}, \code{\link{testInteger}};
  \code{\link{assertList}}, \code{\link{checkList}},
  \code{\link{expect_list}}, \code{\link{testList}};
  \code{\link{assertLogical}}, \code{\link{checkLogical}},
  \code{\link{expect_logical}}, \code{\link{testLogical}};
  \code{\link{assertMatrix}}, \code{\link{checkMatrix}},
  \code{\link{expect_matrix}}, \code{\link{testMatrix}};
  \code{\link{assertNumeric}}, \code{\link{checkNumeric}},
  \code{\link{expect_numeric}}, \code{\link{testNumeric}};
  \code{\link{assertVector}}, \code{\link{checkVector}},
  \code{\link{expect_vector}}, \code{\link{testVector}}
}

