% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reporter.R
\name{reporters-internal}
\alias{reporters-internal}
\alias{report_sleep}
\alias{report_sleep.default}
\alias{report_start_setup}
\alias{report_start_checks}
\alias{report_start_checks.default}
\alias{report_status}
\alias{report_finalize}
\alias{report_task}
\alias{report_step}
\title{Reporter Internal Methods}
\usage{
report_sleep(reporter, checker, sleep)

\method{report_sleep}{default}(reporter, checker, sleep = 1)

report_start_setup(reporter, checker, ..., envir = parent.frame())

report_start_checks(reporter, checker, ..., envir = parent.frame())

\method{report_start_checks}{default}(reporter, checker, ..., envir = parent.frame())

report_status(reporter, checker, envir = parent.frame())

report_finalize(reporter, checker)

report_task(reporter, g, v)

report_step(reporter, checker)
}
\arguments{
\item{reporter}{A object produced using \code{\link{reporters}}. Each reporter is a
thin wrapper around an environment with a class name for dispatch. The
reporter is mutable and captures any necessary state that needs to be
tracked while reporting.}

\item{checker}{\code{\link{checker}} The check checker to report as it evaluates.}

\item{sleep}{\code{numeric} An interval to pause between reporter steps.}

\item{envir}{\code{environment} An environment to attach to, to leverage on-exit
hooks.}
}
\description{
Each of the internal methods for reporters take a reporter, the check
checker object and a calling environment.
}
\keyword{internal}
