% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-available-packages.R
\name{available_packages}
\alias{available_packages}
\title{Available Packages}
\usage{
available_packages(...)
}
\description{
Functionally Equivalent to \code{\link[utils:available.packages]{utils::available.packages()}}, assuming
\code{utils}'s cache doesn't expire in the middle of a top-level call evaluation.
Modifications were made so that the results for queries with unique
arguments are only called once for each top-level expression.
}
\details{
Though \code{\link[utils:available.packages]{utils::available.packages()}} will cache the \code{PACKAGES} index,
it must still be parsed with each call. Since this can happen hundreds of
times when building a \verb{R CMD check} plan, this can cause a signficiant
bottleneck to the responsiveness of this package.

\if{html}{\out{<div class="sourceCode">}}\preformatted{system.time(\{ for (i in 1:10) available.packages() \})
#>    user  system elapsed
#>   3.453   0.196   3.655

system.time(\{ for (i in 1:10) available_packages() \})
#>    user  system elapsed
#>   0.325   0.002   0.328
}\if{html}{\out{</div>}}
}
\note{
This \emph{could} be removed by propagating the \code{available.packages()}
database matrix through all the calls that need to use it, though this
would be a sizable refactor.
}
\keyword{internal}
