% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_discrete.R
\name{as_discrete}
\alias{as_discrete}
\alias{as_discrete.numeric}
\alias{as_discrete.integer64}
\title{Turn continuous data into discrete bins}
\usage{
as_discrete(x, ...)

\method{as_discrete}{numeric}(
  x,
  breaks = get_breaks(x, expand_max = TRUE),
  left_closed = TRUE,
  include_endpoint = FALSE,
  include_oob = FALSE,
  ordered = FALSE,
  intv_start_fun = prettyNum,
  intv_end_fun = prettyNum,
  intv_closers = c("[", "]"),
  intv_openers = c("(", ")"),
  intv_sep = ",",
  ...
)

\method{as_discrete}{integer64}(x, ...)
}
\arguments{
\item{x}{A numeric vector.}

\item{...}{Extra arguments passed onto methods.}

\item{breaks}{Break-points.}

\item{left_closed}{Left-closed intervals or right-closed intervals?}

\item{include_endpoint}{Include endpoint? Default is \code{FALSE}.}

\item{include_oob}{Include out-of-bounds values? Default is \code{FALSE}.}

\item{ordered}{Should result be an ordered factor? Default is \code{FALSE}.}

\item{intv_start_fun}{Function used to format interval start points.}

\item{intv_end_fun}{Function used to format interval end points.}

\item{intv_closers}{A length 2 character vector denoting the symbol
to use for closing either left or right closed intervals.}

\item{intv_openers}{A length 2 character vector denoting the symbol to
use for opening either left or right closed intervals.}

\item{intv_sep}{A length 1 character vector used to separate the start and
end points.}
}
\value{
A factor of discrete bins (intervals of start/end pairs).
}
\description{
Turn continuous data into discrete bins
}
\examples{
library(cheapr)

# `as_discrete()` is very similar to `cut()`
# but more flexible as it allows you to supply
# formatting functions and symbols for the discrete bins

# Here is an example of how to use the formatting functions to
# categorise age groups nicely

ages <- 1:100

age_group <- function(x, breaks){
  age_groups <- as_discrete(
    x,
    breaks = breaks,
    intv_sep = "--",
    intv_end_fun = function(x) x - 1,
    intv_openers = c("", ""),
    intv_closers = c("", ""),
    include_oob = TRUE,
    ordered = TRUE
  )

  # Below is just renaming the last age group

  lvls <- levels(age_groups)
  n_lvls <- length(lvls)
  max_ages <- paste0(max(breaks), "+")
  attr(age_groups, "levels") <- c(lvls[-n_lvls], max_ages)
  age_groups
}

age_group(ages, seq(0, 80, 20))
age_group(ages, seq(0, 25, 5))
age_group(ages, 5)

}
