% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chatRater.R
\name{get_word_frequency}
\alias{get_word_frequency}
\title{Get Word Frequency Information}
\usage{
get_word_frequency(
  stimulus,
  position = "first",
  corpus = "",
  corpus_source = ifelse(corpus != "", "provided", "llm"),
  model = "gpt-3.5-turbo",
  api_key = "",
  top_p = 1,
  temp = 0
)
}
\arguments{
\item{stimulus}{A character string representing the language material.}

\item{position}{A character string indicating which word to analyze ("first", "last", "each", or "total").}

\item{corpus}{An optional character string representing the corpus to use for frequency analysis.}

\item{corpus_source}{A character string, either "provided" or "llm". Default is "provided" if corpus is given, otherwise "llm".}

\item{model}{A character string specifying the LLM model (default "gpt-3.5-turbo").}

\item{api_key}{API key as a character string.}

\item{top_p}{Numeric value for probability mass (default 1).}

\item{temp}{Numeric value for temperature (default 0).}
}
\value{
A numeric value representing the frequency (or a JSON string if "each" is specified).
}
\description{
Uses an LLM to obtain frequency information for a specified word position
in the stimulus. The user can specify a corpus; if none is provided and corpus_source is "llm",
the LLM will generate or assume a representative corpus.
}
\details{
Default definition: "Word frequency is defined as the number of times a word appears in a corpus (often log-transformed)."
}
\examples{
\dontrun{
  freq_first <- get_word_frequency("The quick brown fox jumps over the lazy dog",
                                   position = "first",
                                   corpus = "A sample corpus text with everyday language.",
                                   corpus_source = "provided",
                                   model = "gpt-3.5-turbo",
                                   api_key = "your_api_key")
  cat("Frequency (first word):", freq_first, "\n")
}
}
