% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test.change.point.R
\name{test.change.point}
\alias{test.change.point}
\title{Function to perform changepoint tests with multiplier bootstrap using the usual sequential process}
\usage{
test.change.point(
  x,
  N = 1000,
  n_cores = 2,
  boot.method = "multipliers",
  est = FALSE
)
}
\arguments{
\item{x}{(n x d) matrix of data (observations or pseudo-observations, including residuals), d>=1}

\item{N}{number of multipliers samples to compute the P-value}

\item{n_cores}{number of cores for parallel computing (default = 2)}

\item{boot.method}{bootstrapping method: 'multipliers' (default, fastest) or 'bootstrap'}

\item{est}{if TRUE, tau is estimated (default = FALSE)}
}
\value{
\item{CVM}{Cramer-von Mises statistic}

\item{KS}{Kolmogorov-Smirnov statistic}

\item{pvalueCVM}{Pvalue for the Cramer-von Mises statistic}

\item{pvalueKS}{Pvalue for theKolmogorov-Smirnov statistic}

\item{tauCVM}{Estimated changepoint using the Cramer-von Mises statistic}

\item{tauKS}{Estimated changepoint using the Kolmogorov-Smirnov statistic}
}
\description{
This function compute the Cramer-von Mises and Kolmogorov-Smirnov test statistics based on the new sequential process of Bucher et al (2014), using multipliers and parallel computing.
}
\examples{
x=matrix(rnorm(600),ncol=3)
out = test.change.point(x)


}
\references{
Nasri, B. R. Remillard, B., & Bahraoui, T. (2021). Change-point problems for multivariate time series using pseudo-observations
}
\author{
Bouchra R Nasri  and Bruno N Remillard, August 6, 2020
}
