% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mrc.R
\name{mrc}
\alias{mrc}
\title{Most Recent Changepoints.}
\usage{
mrc(data, cost = "mean", alpha = function(n) 1.5 * log(n), pmax = 5,
  indexed = FALSE, mad = FALSE, phi = 0)
}
\arguments{
\item{data}{An \eqn{n \times N} matrix or data frame representing a length \eqn{n} time series containing observations of \eqn{N} variables. The data can contain missing values
which are indicated by NA.}

\item{cost}{A string indicating which cost function to use. Possible choices are "mean" (change in mean) or "var" (change in variance).
The default value is \code{cost="mean"}.}

\item{alpha}{The variable-specific penalty used to penalise the addition of a given changepoint into a given variable. This can be specified as a real positive value
or as a function of \eqn{n}. The latter form is used when the data contains missing values which leads to time series of different lengths.

Default value \code{alpha=function(n) 1.5*log(n)}.}

\item{pmax}{Maximum number of most recent changepoints to search for. Default value \code{pmax=5}.}

\item{indexed}{Boolean value indicating that the first column of \code{data} is an index variable. If \code{indexed=FALSE} an index variable will automatically be generated.
Default value is \code{indexed=FALSE}.}

\item{mad}{Boolean value indicating if the variates should be scaled by an estimate of the their standard deviation obtained using mean absolute deviation (Zhang, Nancy, Siegmund and David 2007).
This is useful in conjunction with \code{cost="mean"} for which unit variance is assumed. Default value is \code{mad=FALSE}.}

\item{phi}{Lag 1 autocorrelation to model the temporal dependence in the residuals of the time series assuming a MA(1) process. Default \code{phi=0}.}
}
\description{
Detects the Most Recent Changepoints (mrc) for panel data consisting of many related univariate timeseries (Bardwell, Eckley, Fearnhead and Smith, 2016).
The method first determines the most recent univariate changepoints using PELT (Killick, Fearnhead and Eckley 2012) and then pools information across the
time-series by solving the K-median problem using \link[tbart]{tb.raw} (Teitz and Bart, 1968).
}
\examples{
library(changepoint.mv)
data(mrcexample)
res<-mrc(mrcexample,pmax=2)
MDL(res)     # MDL == pmax (possibly under-estimating MDL, retry)
res<-mrc(mrcexample,pmax=6)
MDL(res)     # MDL = 5 (< pmax)
# view the most recent changepoints (corresponding to pmax = 5)
unique(cpts.mr(res,p=5)[,1])
summary(res) # summary of result

}
\references{
\insertRef{doi:10.1080/00401706.2018.1438926}{changepoint.mv}

\insertRef{OR:TEITZBART}{changepoint.mv}

\insertRef{doi:10.1080/01621459.2012.737745}{changepoint.mv}
}
