% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/changepoint.mv.class.R
\docType{methods}
\name{MDL}
\alias{MDL}
\alias{MDL,changepoint.mv.mrc.class-method}
\title{Calculates the Minimum Description Length.}
\usage{
\S4method{MDL}{changepoint.mv.mrc.class}(x)
}
\arguments{
\item{x}{An S4 object as returned by \code{\link{mrc}}.}
}
\value{
The Minimum Description Length (MDL).
}
\description{
Calculates the Minimum Description Length (MDL) using the result obtained from \code{\link{mrc}}. The MDL indicates how many most recent changepoints there are for the data.
For a full definition of the MDL and a description of its calculation see Bardwell, Eckley, Fearnhead and Smith, (2016).
}
\examples{
library(changepoint.mv)
data(mrcexample)
res<-mrc(mrcexample,pmax=8)
MDL(res)

}
\references{
\insertRef{doi:10.1080/00401706.2018.1438926}{changepoint.mv}
}
\seealso{
\code{\link{mrc}}
}
