% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/change_detection.R
\name{changes}
\alias{changes}
\title{A list of change locations occured in the structure having given responses `y` and regressors `x`}
\usage{
changes(x, y, tau = NULL, l = NULL, R = 1000, pzero = 0.05,
  gamma = 0.5, alpha = 1)
}
\arguments{
\item{x}{matrix of regressors with variables in columns and observations in rows}

\item{y}{matrix of responses with variables in columns and observations in rows}

\item{tau}{length of splitting periods (default: l*10, which is dictated by The general rule of thumb \insertCite{Harrell}{changedetection})}

\item{l}{approximate number of contributing variables (default: overall number of regressors)}

\item{R}{number of bootstrap rounds (default: `1000`)}

\item{pzero}{trust level for bootstrap (default: `0.05`)}

\item{gamma}{tau reduction rate used in NSA (default: `0.5`)}

\item{alpha}{parameter for energy distance formula (default: `1`)}
}
\value{
A set of change locations indexes \code{changes}.
}
\description{
The main function of the package which estimates a set of structural change points for a dataset following multivariate (or univariate) linear model.

We consider the following problem. Assume we have observations \eqn{y_t\in{R}^q}, \eqn{x_t\in{R}^p} over time \eqn{t=1,...,N} which follow linear model

                    \deqn{ y_t=  x'_t{\beta}(t)+{\epsilon}_t}

where \eqn{\epsilon_t\in{R}^d} stands for the model noise and \eqn{\beta} is a \eqn{p\times d}-dimensional piecewise-constant function, i.e. \eqn{{\beta}(t)\in{R}^{p\times d}} is a weight matrix for every \eqn{t}. A change point is defined as a time instant \eqn{\hat{t}} where \eqn{\beta} shifts. More precisely, a set of points separating sequential regimes is a set of change points of the model and the objective of \code{detectChanges} function is to find this set.

The approach is based on the splitting procedure NSA \insertCite{gorskikh17}{changedetection} and energy distance analysis \insertCite{rizzo-szekely10}{changedetection}.
}
\examples{
T<-60
change<-35
x<-rnorm(n=T, m=0, sd=1)
e<-scale(rt(n=T,3), scale=FALSE)
y1<-5*x[1:(change-1)]+e[1:(change-1)]
y2<--2*x[change:T]+e[change:T]
y<-c(y1,y2)

changes(x=as.data.frame(x),
        y=as.data.frame(y),
        tau=20, R=100)

}
\references{
\insertAllCited
}
