% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dgev.R
\name{log_gev}
\alias{log_gev}
\title{The Generalised Extreme Value Log-Density Function}
\usage{
log_gev(x, loc = 0, scale = 1, shape = 0)
}
\arguments{
\item{x}{Numeric vectors of quantiles.}

\item{loc, scale, shape}{Numeric scalars.
Location, scale and shape parameters.
\code{scale} must be positive.}
}
\value{
A numeric vector of value(s) of the log-density of the GEV distribution.
}
\description{
Log-Density function of the generalised extreme value (GEV) distribution
}
\details{
\strong{It is assumed that \code{x}, \code{loc} = \eqn{\mu},
 \code{scale} = \eqn{\sigma} and \code{shape} = \eqn{\xi} are such that
 the GEV density is non-zero, i.e. that
 \eqn{1 + \xi (x - \mu) / \sigma > 0}. No check of this, or that
 \code{scale} > 0 is performed in this function.}

 The distribution function of a GEV distribution with parameters
 \code{loc} = \eqn{\mu}, \code{scale} = \eqn{\sigma} (>0) and
 \code{shape} = \eqn{\xi} is
 \deqn{F(x) = exp { - [1 + \xi (x - \mu) / \sigma] ^ (-1/\xi)} }
 for \eqn{1 + \xi (x - \mu) / \sigma > 0}.  If \eqn{\xi = 0} the
 distribution function is defined as the limit as \eqn{\xi} tends to zero.
 The support of the distribution depends on \eqn{\xi}: it is
 \eqn{x <= \mu - \sigma / \xi} for \eqn{\xi < 0};
 \eqn{x >= \mu - \sigma / \xi} for \eqn{\xi > 0};
 and \eqn{x} is unbounded for \eqn{\xi = 0}.
 Note that if \eqn{\xi < -1} the GEV density function becomes infinite
 as \eqn{x} approaches \eqn{\mu -\sigma / \xi} from below.

 See
 \url{https://en.wikipedia.org/wiki/Generalized_extreme_value_distribution}
 for further information.
}
\examples{
log_gev(1:4, 1, 0.5, 0.8)
log_gev(1:3, 1, 0.5, -0.2)
}
\references{
Jenkinson, A. F. (1955) The frequency distribution of the
  annual maximum (or minimum) of meteorological elements.
  \emph{Quart. J. R. Met. Soc.}, \strong{81}, 158-171.
  Chapter 3: \url{http://dx.doi.org/10.1002/qj.49708134804}

Coles, S. G. (2001) \emph{An Introduction to Statistical
  Modeling of Extreme Values}, Springer-Verlag, London.
  \url{http://dx.doi.org/10.1007/978-1-4471-3675-0_3}
}
