% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/function.R
\name{cg_function}
\alias{cg_function}
\title{Create function}
\usage{
cg_function(def, grads = list())
}
\arguments{
\item{def}{function, the definition of the function.}

\item{grads}{list of functions, the gradient functions with respect to each input (optional).}
}
\value{
cg_function object.
}
\description{
Initialize a new function that can be used by operators in a graph.
}
\note{
If the function consumes any inputs, then the gradient function with respect to these inputs must be provided to argument \code{grads}. These gradients must be a function of each input's gradient and take as arguments the inputs of the function including argument \code{value} and \code{grad}. These latter two arguments evaluate to the value of the function and its gradient respectively at run-time.
}
\examples{
#' # Create a custom negation function
f <- cg_function(
    def = function(x) -x,
    grads = list(function(x, value, grad) -grad)
)

}
\author{
Ron Triepels
}
