% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph.R
\name{cg_graph_forward}
\alias{cg_graph_forward}
\title{Forward Pass}
\usage{
cg_graph_forward(graph, target)
}
\arguments{
\item{graph}{cg_graph object, graph that is evaluated.}

\item{target}{cg_node object, node in the graph that is evaluated.}
}
\value{
none.
}
\description{
Perform a forward pass to evaluate a given target node in a graph.
}
\note{
All nodes required to compute the target node must have a value or their value must be able to be computed at run-time. Only those nodes needed to compute the target node (including the target itself) are evaluated.

The value of a node can be retrieved via the \code{values} data member of a \code{cg_node} object.
}
\examples{
# Initialize a computational graph
graph <- cg_graph()

# Add an input
a <- cg_input(name = "a")

# Square the input (i.e. b = a^2)
b <- cg_pow(a, 2, name = "b")

# Set a equal to 2
a$value <- 2

# Perform forward pass
cg_graph_forward(graph, b)

# Retrieve the value of b
b$value

}
\author{
Ron Triepels
}
