% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cgmreport.R
\name{cgmreport}
\alias{cgmreport}
\title{Generate AGP}
\usage{
cgmreport(inputdirectory, outputdirectory = tempdir(), tz = "UTC", 
yaxis = c(0,400))
}
\arguments{
\item{inputdirectory}{The directory containing all cleaned, formatted CGM 
data to be analyzed.}

\item{outputdirectory}{The directory where plot PDF files should be written.}

\item{tz}{The time zone in which the data were recorded.}

\item{yaxis}{The range of the yaxis in mg/dL.}
}
\value{
Aggregate and per subject AGP reports based on all of the cleaned CGM 
data in the input directory.
}
\description{
This function takes a directory of cleaned CGM data and generates two 
aggregate AGPs for all of the files combined. One aggregate AGP is produced 
using Tukey smoothing, and the other uses ggplot's built in LOESS smoothing 
function. The function also produces an AGP plot with each unique subject 
plotted individually on the same graph (using LOESS smoothing).
}
\examples{
cgmreport(system.file("extdata","Cleaned",package = "cgmanalysis"))
}
