% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat.R
\name{compute_time_spent}
\alias{compute_time_spent}
\title{Compute time spent in each state}
\usage{
compute_time_spent(data)
}
\arguments{
\item{data}{data.frame containing \code{id}, id of the trajectory, \code{time}, time at which a change occurs and \code{state}, associated state.}
}
\value{
a matrix with \code{K} columns containing the total time spent in each state for each individual
}
\description{
For each individual, compute the time spent in each state
}
\examples{
# Simulate the Jukes-Cantor model of nucleotide replacement
K <- 4
PJK <- matrix(1 / 3, nrow = K, ncol = K) - diag(rep(1 / 3, K))
lambda_PJK <- c(1, 1, 1, 1)
d_JK <- generate_Markov(n = 10, K = K, P = PJK, lambda = lambda_PJK, Tmax = 10)

# cut at Tmax = 8
d_JK2 <- cut_data(d_JK, Tmax = 8)

# compute time spent by each id in each state
timeSpent <- compute_time_spent(d_JK2)
}
\seealso{
\link{boxplot.timeSpent}

Other Descriptive statistics: 
\code{\link{boxplot.timeSpent}()},
\code{\link{compute_duration}()},
\code{\link{compute_number_jumps}()},
\code{\link{estimate_pt}()},
\code{\link{hist.duration}()},
\code{\link{hist.njump}()},
\code{\link{plot.pt}()},
\code{\link{plotData}()},
\code{\link{statetable}()},
\code{\link{summary_cfd}()}
}
\author{
Cristian Preda, Quentin Grimonprez
}
\concept{Descriptive statistics}
