% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_all_ces_datasets.R
\name{download_all_ces_datasets}
\alias{download_all_ces_datasets}
\title{Download All Canadian Election Study Datasets}
\usage{
download_all_ces_datasets(
  path = NULL,
  years = NULL,
  overwrite = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{path}{A character string indicating the directory where the datasets should
be saved. If NULL (default), the datasets will be saved to the Downloads
directory if available, otherwise to a temporary directory.}

\item{years}{Optional character vector specifying which years to download.
If NULL (default), all available years will be downloaded.}

\item{overwrite}{Logical indicating whether to overwrite existing files.
Default is FALSE.}

\item{verbose}{Logical indicating whether to display detailed progress messages
during download. Default is TRUE.}
}
\value{
Invisibly returns a character vector with the file paths of the downloaded datasets.
}
\description{
This function downloads all available Canadian Election Study datasets to a specified directory.
Each dataset is saved with a standardized filename in the format of \verb{ces_<year>.<format>},
where the format extension corresponds to the original dataset format (e.g., .sav for SPSS,
.dta for Stata).
}
\examples{
\donttest{
# Download all CES datasets to a temporary directory
download_all_ces_datasets(path = tempdir())

# Download only specific years
download_all_ces_datasets(years = c("2015", "2019", "2021"), path = tempdir())

# Download to a temporary directory with overwrite
download_all_ces_datasets(path = tempdir(), overwrite = TRUE)
}

}
