% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/median_center.R
\name{median_center}
\alias{median_center}
\title{Median Center}
\usage{
median_center(x, group, weight, tolerance = 1e-04, ...)
}
\arguments{
\item{x}{Input POINT or POLYGON simple features}

\item{group}{column name(s) specifying groups
to calculate individual mean centers for}

\item{weight}{name of numeric weight column specifying an
individual point's contribution to the mean center}

\item{tolerance}{numeric threshold determining when an
estimate improvement is sufficiently small enough to stop
iterating (smaller = slower, but more precision)}

\item{...}{expressions passed to \code{dplyr::summarise()}}
}
\value{
An sf object with a median center for each group
}
\description{
Median center iteratively calculates the point that minimizes
distance to all features. One can specify the groups to calculate
individual centers for and weights for each individual point. It
is analagous to the \href{https://pro.arcgis.com/en/pro-app/latest/tool-reference/spatial-statistics/median-center.htm}{ArcGIS Pro Median Center}
tool.

It uses the methodology introduced by Kuhn and Kuenne (1962).

Currently, median center is only implemenented for projected data.
}
\examples{
df <- data.frame(
  lon = c(-88, -90, -92, -89, -90),
  lat = c(42, 40, 30, 32, 42),
  grp = c("a", "b", "a", "b", "a"),
  wt = c(1, 1, 1, 1, 1)
)
x <- sf::st_as_sf(df, coords = c("lon", "lat"), crs = 4326)
x_transformed <- sf::st_transform(x, crs = "ESRI:102003")
median_center(x_transformed, group = "grp", weight = "wt")

x_transformed |>
  dplyr::group_by(grp) |>
  median_center(weight = "wt")
}
