% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.r
\name{view_series}
\alias{view_series}
\title{Retrieve data that Censys has about a particular series}
\usage{
view_series(series_id)
}
\arguments{
\item{series_id}{Censys series id (e.g. \code{"22-ssh-banner-full_ipv4"})}
}
\value{
list of specific series details
}
\description{
A "series" is a scan of the same protocol and destination accross time,
including the list of scans.
}
\details{
You must have both \code{CENSYS_API_ID} and \code{CENSYS_API_SECRET} present in the
R environment for the functions in this package to work. It is highly suggested that
you place those in \code{~/.Renviron} at least for interactive work.
}
\examples{
\dontrun{
view_series("443-https-tls-full_ipv4")
}
}
\references{
Census API: \url{https://www.censys.io/api/v1/docs/data}
}

