% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{filterTracks}
\alias{filterTracks}
\title{Filter Tracks}
\usage{
filterTracks(f, x, ...)
}
\arguments{
\item{f}{a function that accepts a single track as its first argument and returns a
logical value (or a value that can be coerced to a locical).}

\item{x}{a tracks object.}

\item{...}{further arguments to be passed on to \code{f}.}
}
\value{
A \code{tracks} object containing only those tracks from \code{x} for which
\code{f} evaluates to \code{TRUE}.
}
\description{
Extracts subtracks based on a given function.
}
\examples{
## Remove short tracks from the T cells data
plot( filterTracks( function(t) nrow(t)>10, TCells ) )
}
