% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ck_cnt_measures.R
\name{ck_cnt_measures}
\alias{ck_cnt_measures}
\title{Utility measures for perturbed counts}
\usage{
ck_cnt_measures(orig, pert, exclude_zeros = TRUE)
}
\arguments{
\item{orig}{a numeric vector holding original values}

\item{pert}{a numeric vector holding perturbed values}

\item{exclude_zeros}{a scalar logical value; if \code{TRUE} (the default), all only cells
with counts \verb{> 0} are used when computing distances \code{d1}, \code{d2} and \code{d3}. If this
argument is \code{FALSE}, the complete vector is used.}
}
\value{
a \code{list} containing the following elements:
\itemize{
\item \code{overview}: a \code{data.table} with the following three columns:
\itemize{
\item \code{noise}: amount of noise computed as \code{orig} - \code{pert}
\item \code{cnt}: number of cells perturbed with the value given in column \code{noise}
\item \code{pct}: percentage of cells perturbed with the value given in column \code{noise}
}
\item \code{measures}: a \code{data.table} containing measures of the distribution
of three different distances between original and perturbed values
of the unweighted counts. Column \code{what} specifies the computed measure.
The three distances considered are:
\itemize{
\item \code{d1}: absolute distance between original and masked values
\item \code{d2}: relative absolute distance between original and masked values
\item \code{d3}: absolute distance between square-roots of original and perturbed
values
}
\item \code{cumdistr_d1}, \code{cumdistr_d2} and \code{cumdistr_d3}: for each distance \code{d1}, \code{d2}
and \code{d3}, a \code{data.table} with the following three columns:
\itemize{
\item \code{cat}: a specific value (for \code{d1}) or interval (for distances \code{d2} and \code{d3})
\item \code{cnt}: number of records smaller or equal the value in column \code{cat} for the
given distance
\item \code{pct}: proportion of records smaller or equal the value
in column \code{cat} for the selected distance
}
\item \code{false_zero}: number of cells that were perturbed to zero
\item \code{false_nonzero}: number of cells that were initially zero but
have been perturbed to a number different from zero
\item \code{exclude_zeros}: were empty cells exluded from computation or not
}
}
\description{
This function computes utility/information loss measures
based on two numeric vectors (original and perturbed)
}
\examples{
orig <- c(1:10, 0, 0)
pert <- orig; pert[c(1, 5, 7)] <- c(0, 6, 9)

# ignore empty cells when computing measures `d1`, `d2`, `d3`
ck_cnt_measures(orig = orig, pert = pert, exclude_zeros = TRUE)

# use all cells
ck_cnt_measures(orig = orig, pert = pert, exclude_zeros = FALSE)

# for an application on a perturbed object, see ?cellkey_pkg
}
