% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is.Qid.R
\name{is.Qid}
\alias{is.Qid}
\title{Check whether a Q-matrix is identifiable}
\usage{
is.Qid(Q, model)
}
\arguments{
\item{Q}{A \emph{J} items x \emph{K} attributes Q-matrix (\code{matrix} or \code{data.frame}).}

\item{model}{CDM to be considered. It includes \code{"DINA"}, \code{"DINO"}, or \code{"others"} (for other CDMs; e.g., G-DINA, A-CDM).}
}
\value{
\code{is.Qid} returns an object of class \code{is.Qid}.
\describe{
\item{\code{strict}}{Is the Q-matrix strictly identifiable? (\code{logical}).}
\item{\code{generic}}{Is the Q-matrix generically identifiable?  (\code{logical}).}
\item{\code{conditions}}{Identifiability criteria and whether they are fulfilled or not (\code{vector}).}
\item{\code{specifications}}{Function call specifications (\code{list}).}
}
}
\description{
Checks whether a Q-matrix fulfills the conditions for strict and generic identifiability according to Gu & Xu (2021).
}
\examples{
Kj <- c(15, 10, 0, 5)
Q <- genQ(J = 30, K = 4, Kj = Kj, Qid = "others", seed = 123)$gen.Q
idQ <- is.Qid(Q, model = "DINA")
}
\references{
Gu, Y., & Xu, G. (2021). Sufficient and necessary conditions for the identifiability of the Q-matrix. \emph{Statistica Sinica}, \emph{31}, 449-472. https://www.jstor.org/stable/26969691
}
\author{
{Pablo Nájera, Universidad Pontificia Comillas \cr Miguel A. Sorrel, Universidad Autónoma de Madrid}
}
