% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DIDparams.R
\name{DIDparams}
\alias{DIDparams}
\title{DIDparams}
\usage{
DIDparams(
  yname,
  tname,
  idname = NULL,
  gname,
  xformla = NULL,
  data,
  control_group,
  anticipation = 0,
  weightsname = NULL,
  alp = 0.05,
  bstrap = TRUE,
  biters = 1000,
  clustervars = NULL,
  cband = TRUE,
  print_details = TRUE,
  pl = FALSE,
  cores = 1,
  est_method = "chained",
  base_period = "varying",
  panel = TRUE,
  true_repeated_cross_sections,
  n = NULL,
  nG = NULL,
  nT = NULL,
  tlist = NULL,
  glist = NULL,
  call = NULL
)
}
\arguments{
\item{yname}{The name of the outcome variable}

\item{tname}{The name of the column containing the time periods}

\item{idname}{The individual (cross-sectional unit) id name}

\item{gname}{The name of the variable in \code{data} that
contains the first period when a particular observation is treated.
This should be a positive number for all observations in treated groups.
It defines which "group" a unit belongs to.  It should be 0 for units
in the untreated group.}

\item{xformla}{A formula for the covariates to include in the
model.  It should be of the form \code{~ X1 + X2}.  Default
is NULL which is equivalent to \code{xformla=~1}.  This is
used to create a matrix of covariates which is then passed
to the 2x2 DID estimator chosen in \code{est_method}.
X's are assumed fixed across the time dimension in this version.
Use different columns Xt, Xt+1 if time-varying covariates are needed.}

\item{data}{The name of the data.frame that contains the data}

\item{control_group}{Which units to use the control group.
The default is "nevertreated" which sets the control group
to be the group of units that never participate in the
treatment.  This group does not change across groups or
time periods.  The other option is to set
\code{group="notyettreated"}.  In this case, the control group
is set to the group of units that have not yet participated
in the treatment in that time period.  This includes all
never treated units, but it includes additional units that
eventually participate in the treatment, but have not
participated yet.}

\item{anticipation}{(Not used) The number of time periods before participating
in the treatment where units can anticipate participating in the
treatment and therefore it can affect their untreated potential outcomes}

\item{weightsname}{The name of the column containing the sampling weights.
If not set, all observations have same weight.}

\item{alp}{the significance level, default is 0.05}

\item{bstrap}{Boolean for whether or not to compute standard errors using
the multiplier bootstrap.  If standard errors are clustered, then one
must set \code{bstrap=TRUE}. Default is \code{TRUE} (in addition, cband
is also by default \code{TRUE} indicating that uniform confidence bands
will be returned.  If bstrap is \code{FALSE}, then analytical
standard errors are reported.}

\item{biters}{The number of bootstrap iterations to use.  The default is 1000,
and this is only applicable if \code{bstrap=TRUE}.}

\item{clustervars}{A vector of variables names to cluster on.  At most, there
can be two variables (otherwise will throw an error) and one of these
must be the same as idname which allows for clustering at the individual
level. By default, we cluster at individual level (when \code{bstrap=TRUE}).}

\item{cband}{Boolean for whether or not to compute a uniform confidence
band that covers all of the group-time average treatment effects
with fixed probability \code{1-alp}.  In order to compute uniform confidence
bands, \code{bstrap} must also be set to \code{TRUE}.  The default is
\code{TRUE}.}

\item{print_details}{Whether or not to show details/progress of computations.
Default is \code{FALSE}.}

\item{pl}{Whether or not to use parallel processing}

\item{cores}{The number of cores to use for parallel processing}

\item{est_method}{the method to compute group-time average treatment effects.  At the moment, one can only use the IPW estimator
with either "2-step" or "Identity" weighting matrix to aggregate Delta ATT into ATT.
include "ipw" for inverse probability weighting and "reg" for
first step regression estimators.}

\item{base_period}{(Not used) The cdid package only uses the g-1 base period for the moment. Whether to use a "varying" base period or a
"universal" base period.  Either choice results in the same
post-treatment estimates of ATT(g,t)'s.  In pre-treatment
periods, using a varying base period amounts to computing a
pseudo-ATT in each treatment period by comparing the change
in outcomes for a particular group relative to its comparison
group in the pre-treatment periods (i.e., in pre-treatment
periods this setting computes changes from period t-1 to period
t, but repeatedly changes the value of t)

A universal base period fixes the base period to always be
(g-anticipation-1).  This does not compute
pseudo-ATT(g,t)'s in pre-treatment periods, but rather
reports average changes in outcomes from period t to
(g-anticipation-1) for a particular group relative to its comparison
group.  This is analogous to what is often reported in event
study regressions.

Using a varying base period results in an estimate of
ATT(g,t) being reported in the period immediately before
treatment.  Using a universal base period normalizes the
estimate in the period right before treatment (or earlier when
the user allows for anticipation) to be equal to 0, but one
extra estimate in an earlier period.}

\item{panel}{(Not used) This is not used as balanced and unbalanced panel data is treated similarly.}

\item{true_repeated_cross_sections}{Whether or not the data really
is repeated cross sections.  (We include this because unbalanced
panel code runs through the repeated cross sections code)}

\item{n}{The number of observations.  This is equal to the
number of units (which may be different from the number
of rows in a panel dataset).}

\item{nG}{The number of groups}

\item{nT}{The number of time periods}

\item{tlist}{a vector containing each time period}

\item{glist}{a vector containing each group}

\item{call}{(Not used) a call control var}
}
\value{
A \code{DIDparams} object, which is a list containing the following elements:
\itemize{
\item \code{yname}: The name of the outcome variable.
\item \code{tname}: The name of the time variable.
\item \code{idname}: The name of the unit identifier variable (if applicable).
\item \code{gname}: The name of the group variable (e.g., treatment group).
\item \code{xformla}: A formula specifying covariates for the model.
\item \code{data}: The dataset used for analysis.
\item \code{control_group}: The type of control group (e.g., "never treated" or "not yet treated").
\item \code{anticipation}: The number of periods of anticipation before treatment.
\item \code{weightsname}: The name of the variable containing sampling weights (if applicable).
\item \code{alp}: The significance level (default is 0.05).
\item \code{bstrap}: Logical. Indicates whether bootstrap is used for standard errors.
\item \code{biters}: The number of bootstrap iterations (if bootstrap is enabled).
\item \code{clustervars}: Variables used for clustering standard errors.
\item \code{cband}: Logical. Indicates whether simultaneous confidence bands are computed.
\item \code{print_details}: Logical. Indicates whether detailed results should be printed.
\item \code{pl}: Logical. Parallelization flag for computations.
\item \code{cores}: The number of cores to use for parallelization (if enabled).
\item \code{est_method}: The estimation method (e.g., "chained").
\item \code{base_period}: The base period used for comparison (e.g., "varying").
\item \code{panel}: Logical. Indicates whether the data is a panel dataset.
\item \code{true_repeated_cross_sections}: Logical. Indicates whether the data is truly repeated cross-sections.
\item \code{n}: The number of observations (units).
\item \code{nG}: The number of groups.
\item \code{nT}: The number of time periods.
\item \code{tlist}: A vector containing all time periods.
\item \code{glist}: A vector containing all groups.
\item \code{call}: The call that generated the \code{DIDparams} object.
}
}
\description{
Creates a \code{DIDparams} object to hold parameters for difference-in-differences analysis,
including data structure details and user-specified options. This object is designed to streamline
parameter passing across functions in the \code{cdid} package.#'
}
\seealso{
\code{\link{pre_process_cdid}}
}
