% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chemical-APIs.R
\name{get_chem_info}
\alias{get_chem_info}
\title{Retrieve chemical information}
\usage{
get_chem_info(
  DTXSID = NULL,
  type = "",
  API_key = NULL,
  Server = chemical_api_server,
  verbose = FALSE
)
}
\arguments{
\item{DTXSID}{The chemical identifier DTXSID}

\item{type}{This specifies whether to only grab predicted or experimental
results. If not specified, it will grab all details. The allowable input
values are "predicted" or "experimental".}

\item{API_key}{The user-specific API Key}

\item{Server}{The root address for the API endpoint}

\item{verbose}{A logical indicating if some “progress report” should be given.}
}
\value{
A data.frame containing chemical information for the chemical with
DTXSID matching the input parameter.
}
\description{
Retrieve chemical information
}
\examples{
\dontshow{if (has_ccte_key() & is.na(ccte_key() == 'FAKE_KEY')) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Pull chemical information for BPA
bpa <- get_chem_info(DTXSID = 'DTXSID7020182')
\dontshow{\}) # examplesIf}
}
