% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_power_ccc.R
\name{sim_power_ccc}
\alias{sim_power_ccc}
\title{Power and confidence interval range}
\usage{
sim_power_ccc(
  n = 30,
  nrep = 2,
  nsim = 300,
  r0 = 0,
  alpha = 0.05,
  model = NULL,
  b = NULL,
  g = NULL,
  mu = 0,
  sa = 1,
  sab = 0,
  sag = 0,
  bg = NULL,
  se = 1,
  extra.info = TRUE,
  vecD = NULL,
  covar = NULL,
  int = FALSE,
  rho = 0,
  cl = 0.95,
  control.lme = list(),
  transf = "F2",
  future_seed = TRUE,
  workers = 15
)
}
\arguments{
\item{n}{Integer. Number of subjects}

\item{nrep}{Integer. Number of replicates}

\item{nsim}{Integer. Number of data sets simulated.}

\item{r0}{Integer. Null hypothesis value.}

\item{alpha}{Type-I error rate.}

\item{model}{object of class \code{lme}.}

\item{b}{Vector. Method fixed effects.}

\item{g}{Vector. Time fixed effects.}

\item{mu}{Integer. Overall mean.}

\item{sa}{Integer. Standard deviation of subject's random effect.}

\item{sab}{Integer. Standard deviation of subject-method interaction's random effect.}

\item{sag}{Integer. Standard deviation of subject-time interaction's random effect.}

\item{bg}{Vector. Method-time interaction's fixed effects}

\item{se}{Integer. Standard deviation of random error effect.}

\item{extra.info}{Logical. Should the information about CCC and variance components simulated be shown?  Default is set to TRUE.}

\item{vecD}{Vector of weights. The length of the vector must be the same as the number of repeated measures.}

\item{covar}{Character vector. Name of covariates to include in the linear mixed model as fixed effects.}

\item{int}{Binary indicating if the subject-method interaction has to be included in the model when analyzing the non-longitudinal setting (defaults to FALSE).}

\item{rho}{Within subject correlation structure. A value of 0 (default option) stands for compound symmetry and 1 is used for autorregressive of order 1 structure.}

\item{cl}{Confidence level.}

\item{control.lme}{A list of control values for the estimation algorithm used in \code{lme} function. For further details see \code{lme} help.}

\item{transf}{Character string. Whether to apply a transformation of the coefficient for inference. Valid options are: "F" for Fisher's Z-transformation; "F2" For Fisher's Z-transformation setting m=2 (default); "KG" Konishi-Gupta transformasion; "None", no transformation is applied. See *Details* for further information.}

\item{future_seed}{Logical/Integer. The seed to be used for parallellization. Further details in \code{furrr_options}.}

\item{workers}{Integer. Number of cores to be used for parallellization. Default is 15. Capped to number of available cores minus 1.}
}
\value{
A data frame with the following components:
\itemize{
\item \code{n} Number of subjects
\item \code{reps} Number of replicates
\item \code{CCC}. Median of the CCC estimates.
\item \code{Power}. Empirical power computed as proportion of times the null hypothesis is rejected using a type-I error rate of \code{alpha}.
\item \code{SEICC}. Average of CCC standard errors.
\item \code{SEZ}. Average of transformed CCC standard errors.
\item \code{Range IC95}. Average of CCC confidence interval widths.
}
}
\description{
Power and confidence interval range obtained by simulation
}
\details{
The power and the range of the confidence interval are computed using the approach suggested in Choudhary and Nagaraja (2018). Data sets are simulated by setting the fixed effects values and the standard deviation of the random effects. The CCC and its standard error are estimated in each data set, along with its 95\% confidence interval and the Wald test \code{\link{Ztest}}.
}
\examples{
\donttest{
# Power to test the CCC is above 0.8 with 35 subjects and 4 replicates.
# Two methods, three times. Simulated CCC=0.87.
sim_pw<-sim_power_ccc(n = 35, nrep=4, nsim=500, r0=0.8, b = c(-0.5,0.5), 
g=c(-0.25,0,0.25), mu = -0.25, sa = 4,sab=0.5,sag=1,
bg=c(-0.5,-0.25,0.25,-0.5,0.25,0.75),se = 1)
}



}
\references{
Choudhary, P.K. and Nagaraja, H.N. (2018). Measuring Agreement-Models, Methods, and Applications. John Wiley & Sons
}
