% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cbs_get_maps.R
\name{cbs_get_maps}
\alias{cbs_get_maps}
\title{Get list of cbs maps}
\usage{
cbs_get_maps(verbose = FALSE, cache = TRUE)
}
\arguments{
\item{verbose}{if \code{TRUE} a message with the download url will be printed.}

\item{cache}{if \code{TRUE} the result will be cached.}
}
\value{
\code{data.frame} with region, year and links to geojson
}
\description{
Returns a list of (simplified) maps, that can be used with CBS data.
}
\examples{
if (interactive()){
  
  # retrieve maps
  cbs_maps <- cbs_get_maps()
  cbs_maps |> head(4)
  
  gemeente_map <- cbs_get_sf("gemeente", 2023, verbose=TRUE)
  
  # sf object
  gemeente_map
  
  # plot the statcodes (included in the map)
  plot(gemeente_map, max.plot = 1)
  
  # now connect with some data
  labor <- cbs_get_data("85268NED"
                       , Perioden = "2022JJ00" # only 2022
                       , RegioS = has_substring("PV") # only province
                       , verbose = TRUE
                       )
  
  # most conveniently
  provincie_2022_with_data <- cbs_join_sf_with_data("provincie", 2022, labor)
  
  # better plotting options are ggplot2 or tmap, 
  # but keeping dependencies low...
  provincie_2022_with_data |> 
    subset(select = Werkloosheidspercentage_13) |> 
    plot( border ="#FFFFFF99", main="unemployment rate")
  
  ## but of course this can also be done by hand:
  labor <- labor |> 
    cbs_add_statcode_column()  # add column to connect with map
  
  provincie_2022 <- cbs_get_sf("provincie", 2022)
  
  # this is a left_join(provincie_2022, labor, by = "statcode")
  provincie_2022_data <- 
    within(provincie_2022, {
      unemployment_rate <- labor$Werkloosheidspercentage_13[match(statcode, labor$statcode)]
    }) 
  
  # better plotting options are ggplot2 or tmap, 
  # but keeping dependencies low...
  plot( provincie_2022_data[,c("unemployment_rate")]
      , border ="#FFFFFF99"
      , nbreaks = 12
      )
}
}
\seealso{
Other cartographic map: 
\code{\link{cbs_add_statcode_column}()},
\code{\link{cbs_get_sf}()},
\code{\link{cbs_join_sf_with_data}()}
}
\concept{cartographic map}
