% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get-themes.R
\name{get_themes}
\alias{get_themes}
\title{Get list of all cbs thematic entries.}
\usage{
get_themes(..., select = NULL, verbose = TRUE, cache = FALSE,
  base_url = CBSOPENDATA)
}
\arguments{
\item{...}{Use this to add a filter to the query e.g. \code{get_themes(ID=10)}.}

\item{select}{\code{character} vector with names of wanted properties. default is all}

\item{verbose}{Print extra messages what is happening.}

\item{cache}{Should the result be cached?}

\item{base_url}{optionally specify a different server. Useful for
third party data services implementing the same protocal.}
}
\value{
A \code{data.frame} with various properties of SN/CBS themes.

The filter is specified with \code{<column_name> = <values>} in which \code{<values>} is a character vector.
Rows with values that are not part of the character vector are not returned.
}
\description{
Returns a list of all cbs themes.
}
\examples{
\dontrun{
# get list of all themes
get_themes()

# get list of all dutch themes from the Catalog "CBS"
get_themes(Language="nl", Catalog="CBS")
}
}
