% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genomics_by_sample.R
\name{.get_data_by_sample}
\alias{.get_data_by_sample}
\title{Internal Function to Get Mutations/CNA/Fusion By Sample ID}
\usage{
.get_data_by_sample(
  sample_id = NULL,
  study_id = NULL,
  molecular_profile_id = NULL,
  sample_study_pairs = NULL,
  data_type = c("mutation", "cna", "fusion", "structural_variant", "segment"),
  genes = NULL,
  panel = NULL,
  add_hugo = TRUE,
  base_url = NULL
)
}
\arguments{
\item{sample_id}{a vector of sample IDs (character)}

\item{study_id}{A string indicating the study ID from which to pull data. If no study ID, will
guess the study ID based on your URL and inform. Only 1 study ID can be passed. If mutations/cna from
more than 1 study needed, see \code{sample_study_pairs}}

\item{molecular_profile_id}{A string indicating the molecular profile ID from which to pull data. If ID supplied, will
guess the molecular profile ID based on the study ID. Only 1 molecular profile ID can be passed. If mutations from
more than 1 study needed, see \code{sample_study_pairs}}

\item{sample_study_pairs}{A dataframe with columns: \code{sample_id}, \code{study_id} and \code{molecular_profile_id} (optional). Variations in capitalization of column names are accepted.
This can be used in place of \code{sample_id}, \code{study_id}, \code{molecular_profile_id} arguments above if you
need to pull samples from several different studies at once. If passed this will take overwrite \code{sample_id}, \code{study_id}, \code{molecular_profile_id} if also passed.}

\item{data_type}{specify what type of data to return. Options are\code{mutations}, \code{cna}, \code{fusion} or \code{structural_variant} (same as \code{fusion}).}

\item{genes}{A vector of Entrez ids or Hugo symbols. If Hugo symbols are supplied, they will be converted to entrez ids using the \code{get_entrez_id()} function.
If \code{panel} and \code{genes} are both supplied, genes from both arguments will be returned. If both are NULL (default), it will return gene results for all available genomic data for that sample.}

\item{panel}{One or more panel IDs to query (e.g. 'IMPACT468').
If \code{panel} and \code{genes} are both supplied, genes from both arguments will be returned. If both are NULL (default), it will return gene results for all available genomic data for that sample.}

\item{add_hugo}{Logical indicating whether \code{HugoGeneSymbol} should be added to your resulting data frame, if not already present in raw API results.
Argument is \code{TRUE} by default. If \code{FALSE}, results will be returned as is (i.e. any existing Hugo Symbol columns in raw results will not be removed).}

\item{base_url}{The database URL to query
If \code{NULL} will default to URL set with \verb{set_cbioportal_db(<your_db>)}}
}
\value{
A dataframe of mutations, CNAs or fusions.
}
\description{
Internal Function to Get Mutations/CNA/Fusion By Sample ID
}
\examples{
\dontrun{
set_cbioportal_db("public")
.get_data_by_sample(sample_id = c("TCGA-OR-A5J2-01","TCGA-OR-A5J6-01"),
 study_id = "acc_tcga", data_type = "mutation")

.get_data_by_sample(sample_id = c("DS-sig-010-P2"),
 molecular_profile_id = "blca_plasmacytoid_mskcc_2016_cna", data_type = "cna")


.get_data_by_sample(sample_id = c("P-0002146-T01-IM3"),
 study_id = "blca_plasmacytoid_mskcc_2016", data_type = "fusion")

df_pairs <- data.frame(
"sample_id" = c("s_C_36924L_P001_d",
"s_C_03LNU8_P001_d"),
"study_id" = c("prad_msk_2019"))

.get_data_by_sample(sample_study_pairs = df_pairs, data_type = "mutation")
.get_data_by_sample(sample_study_pairs = df_pairs, genes = 7157, data_type = "mutation")
.get_data_by_sample(sample_study_pairs = df_pairs, data_type = "cna")
.get_data_by_sample(sample_study_pairs = df_pairs, data_type = "fusion")

df_pairs2 <- data.frame(
"sample_id" = c("P-0002146-T01-IM3", "s_C_CAUWT7_P001_d"),
 "study_id" = c("blca_plasmacytoid_mskcc_2016", "prad_msk_2019"))

.get_data_by_sample(sample_study_pairs = df_pairs2, data_type = "mutation")
.get_data_by_sample(sample_study_pairs = df_pairs2, genes = 7157)
.get_data_by_sample(sample_study_pairs = df_pairs2, data_type = "cna")
.get_data_by_sample(sample_study_pairs = df_pairs2, data_type = "fusion")
}

}
\keyword{internal}
