% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ol_comp_byindex.R
\name{ol_comp_byindex}
\alias{ol_comp_byindex}
\title{Calculate Overload Compensation for One Instructor (by Index)}
\usage{
ol_comp_byindex(
  i,
  schedule_df,
  L = 4,
  U = 9,
  rate_per_cr = 2500/3,
  reg_load = 12,
  favor_institution = TRUE
)
}
\arguments{
\item{i}{Integer index of the instructor (as returned by \code{get_unique_instructors()}).}

\item{schedule_df}{A data frame of the full course schedule containing an \code{INSTRUCTOR} column.}

\item{L}{Lower enrollment threshold for overload pay eligibility (inclusive). Default is 4.}

\item{U}{Upper enrollment limit for proration (inclusive). Default is 9.}

\item{rate_per_cr}{Overload pay rate per qualified credit hour. Default is 2500/3.}

\item{reg_load}{Regular teaching load in credit hours. Default is 12.}

\item{favor_institution}{Logical: if TRUE (default), favors the institution by prioritizing
high-enrollment courses for regular load.}
}
\value{
Invisibly returns a tibble with the instructor’s course-level overload compensation summary.
}
\description{
Retrieves an instructor's name by index from the schedule and calculates their overload compensation
using \code{ol_comp()}. Returns a clean, readable course-level compensation summary.
}
\details{
If \code{favor_institution = TRUE} (default), the function assigns high-enrollment
courses to the regular load first, minimizing compensation.

If \code{favor_institution = FALSE}, low-enrollment courses are used toward the regular load first,
preserving high-enrollment courses for overload pay.

This function internally uses \code{get_instructor_schedule()}, which supports flexible,
case-insensitive regex matching for instructor names (e.g., \code{"^smith$"} or \code{"johnson|williams"}).
}
\examples{
# Example usage with a schedule dataframe:
# ol_comp_byindex(1, schedule_df = schedule)

}
