% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cata.R
\encoding{UTF-8}
\name{barray}
\alias{barray}
\title{Convert 3d array of CATA data to 4d array of CATA differences}
\usage{
barray(X, values = "bc")
}
\arguments{
\item{X}{three-dimensional array (\code{I} assessors, \code{J}
products, \code{M} attributes) where values are \code{0} (not checked) 
or \code{1} (checked)}

\item{values}{\code{"bc"} (default) returns two outcomes: \code{b} and 
\code{c}; otherwise \code{"abcd"} returns four outcomes: \code{a}, \code{b}, 
\code{c}, \code{d}.}
}
\value{
A four-dimensional array of product comparisons having \code{I} 
assessors, \code{J(J-1)/2} product comparisons, outcomes (see \code{values}
parameter), \code{M} attributes
}
\description{
Converts a three-dimensional array (\code{I} assessors, \code{J}
products, \code{M} attributes) to a four-dimensional array of product
comparisons (\code{I} assessors, \code{J(J-1)/2}
product comparisons, two outcomes (of type \code{b} or \code{c}), \code{M} 
attributes)
}
\examples{
data(bread)

# Get the 4d array of CATA differences for the first 10 consumers
b <- barray(bread$cata[1:10,,])
}
\references{
Castura, J.C., Meyners, M., Varela, P., & Næs, T. (2021). 
Clustering consumers based on product discrimination in check-all-that-apply 
(CATA) data. \emph{Food Quality and Preference}, submitted.

McNemar, Q. (1947). Note on the sampling error of the difference between
correlated proportions or percentages. \emph{Psychometrika}, 12, 153-157,
\doi{10.1007/BF02295996}.
}
