% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{probability}
\alias{probability}
\title{Probability of Responses to a Question Item or the Left-Cumulative Probability of Responses}
\usage{
probability(catObj, theta, item)
}
\arguments{
\item{catObj}{An object of class \code{Cat}}

\item{theta}{A numeric or an integer indicating the value for \eqn{\theta_j}}

\item{item}{An integer indicating the index of the question item}
}
\value{
When the \code{model} slot of the \code{catObj} is \code{"ltm"}, the function \code{probability} returns a numeric vector of length one representing the probability of observing a non-zero response.

When the \code{model} slot of the \code{catObj} is \code{"tpm"}, the function \code{probability} returns a numeric vector of length one representing the probability of observing a non-zero response.

When the \code{model} slot of the \code{catObj} is \code{"grm"}, the function \code{probability} returns a numeric vector of length k+1, where k is the number of possible responses. The first element will always be zero and the (k+1)th element will always be one. The middle elements are the cumulative probability of observing response k or lower.

 When the \code{model} slot of the \code{catObj} is \code{"gpcm"}, the function \code{probability} returns a numeric vector of length k, where k is the number of possible responses. Each number represents the probability of observing response k.
}
\description{
Calculates the probability of specific responses or the left-cumulative probability of responses to \code{item} conditioned on a respondent's ability (\eqn{\theta}).
}
\details{
For the \code{ltm} model, the probability of non-zero response for respondent \eqn{j} on item \eqn{i} is
 
 \deqn{Pr(y_{ij}=1|\theta_j)=\frac{\exp(a_i + b_i \theta_j)}{1+\exp(a_i + b_i \theta_j)}}

 where \eqn{\theta_j} is respondent \eqn{j} 's position on the latent scale of interest, \eqn{a_i} is item \eqn{i} 's discrimination parameter,
 and \eqn{b_i} is item \eqn{i} 's difficulty parameter. 
 
 For the \code{tpm} model, the probability of non-zero response for respondent \eqn{j} on item \eqn{i} is
 
 \deqn{Pr(y_{ij}=1|\theta_j)=c_i+(1-c_i)\frac{\exp(a_i + b_i \theta_j)}{1+\exp(a_i + b_i \theta_j)}}

 where \eqn{\theta_j} is respondent \eqn{j} 's position on the latent scale of interest, \eqn{a_i} is item \eqn{i} 's discrimination parameter,
 \eqn{b_i} is item \eqn{i} 's difficulty parameter, and \eqn{c_i} is item \eqn{i} 's guessing parameter. 
 
 For the \code{grm} model, the probability of a response in category \eqn{k} \strong{or lower} for respondent \eqn{j} on item \eqn{i} is

 \deqn{Pr(y_{ij} <  k|\theta_j)=\frac{\exp(\alpha_{ik} - \beta_i \theta_{ij})}{1+\exp(\alpha_{ik} - \beta_i \theta_{ij})}}{Pr(y_ij < k | \theta_j) = (exp(\alpha_ik - \beta_i \theta_ij))/(1 + exp(\alpha_ik - \beta_i \theta_ij))}

 where \eqn{\theta_j} is respondent \eqn{j} 's position on the latent scale of interest, \eqn{\alpha_ik} the \eqn{k}-th element of item \eqn{i} 's difficulty parameter, 
 \eqn{\beta_i} is discrimination parameter vector for item \eqn{i}. Notice the inequality on the left side and the absence of guessing parameters.

 For the \code{gpcm} model, the probability of a response in category \eqn{k} for respondent \eqn{j} on item \eqn{i} is

 \deqn{Pr(y_{ij} =  k|\theta_j)=\frac{\exp(\sum_{t=1}^k \alpha_{i} [\theta_j - (\beta_i - \tau_{it})])}
 {\sum_{r=1}^{K_i}\exp(\sum_{t=1}^{r} \alpha_{i} [\theta_j - (\beta_i - \tau_{it}) )}}
 
 
 where \eqn{\theta_j} is respondent \eqn{j} 's position on the latent scale of interest, \eqn{\alpha_i} is the discrimination parameter for item \eqn{i},
 \eqn{\beta_i} is the difficulty parameter for item \eqn{i}, and \eqn{\tau_{it}} is the category \eqn{t} threshold parameter for item \eqn{i}, with \eqn{k = 1,...,K_i} response options
 for item \eqn{i}.  For identification purposes \eqn{\tau_{i0} = 0} and \eqn{\sum_{t=1}^1 \alpha_{i} [\theta_j - (\beta_i - \tau_{it})] = 0}.
}
\note{
This function is to allow users to access the internal functions of the package. During item selection, all calculations are done in compiled \code{C++} code.
}
\examples{
## Loading ltm Cat object
## Probability for Cat object of the ltm model
data(ltm_cat)
probability(ltm_cat, theta = 1, item = 1)

## Loading tpm Cat object
## Probability for Cat object of the tpm model
probability(tpm_cat, theta = 1, item = 1)

## Loading grm Cat object
## Probability for Cat object of the grm model
probability(grm_cat, theta = 1, item = 1)

## Loading gpcm Cat object
## Probability for Cat object of the gpcm model
probability(gpcm_cat, theta = -3, item = 2)
 
}
\references{
Baker, Frank B. and Seock-Ho Kim. 2004. Item Response Theory: Parameter Estimation Techniques. New York: Marcel Dekker.

Choi, Seung W. and Richard J. Swartz. 2009. ``Comparison of CAT Item Selection Criteria for Polytomous Items." Applied Psychological Measurement 33(6):419-440.

Muraki, Eiji. 1992. ``A generalized partial credit model: Application of an EM algorithm." ETS Research Report Series 1992(1):1-30.

van der Linden, Wim J. 1998. ``Bayesian Item Selection Criteria for Adaptive Testing." Psychometrika 63(2):201-216.
}
\seealso{
\code{\link{Cat-class}}
}
\author{
Haley Acevedo, Ryden Butler, Josh W. Cutler, Matt Malis, Jacob M. Montgomery,
 Tom Wilkinson, Erin Rossiter, Min Hee Seo, Alex Weil
}
