% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_levels.R
\name{create_levels}
\alias{create_levels}
\title{CAT decision tree level generator}
\usage{
create_levels(
  nodes_prev,
  bank,
  crit,
  C,
  nres,
  level,
  prob_array,
  limit,
  tol,
  inters
)
}
\arguments{
\item{nodes_prev}{list of node lists of the nodes from the previous level}

\item{bank}{matrix of the item bank. Rows represent items, and columns
represent parameters. If the model is \code{"GRM"}, the first column
represents the \code{alpha} parameters and the next columns represent the
\code{beta} parameters. If the model is \code{"NRM"}, odd columns represent
the \code{alpha} parameters and even columns represent \code{beta}
parameters}

\item{crit}{item selection criterion. Options: "MEPV" for Minimum
Expected Posterior Variance and "MFI" for Maximum Fisher Information}

\item{C}{vector of item capacities}

\item{nres}{vector of number of possible responses for every item}

\item{level}{level number}

\item{prob_array}{3-D array of probability responses. Dim 1 represent items,
dim 2 represent evaluated ability levels and dim 3 represent possible
responses}

\item{limit}{maximum number of level nodes}

\item{tol}{maximum distance between estimated ability levels in the nodes
of the evaluated pair in order to consider whether to join them}

\item{inters}{minimum common area between density functions in the nodes of
the evaluated pair in order to join them}
}
\value{
A list of lists. Each of these lists represent a node of the
specified level of the decision tree
}
\description{
Generates a list of node lists for a specific level of the CAT decision tree
}
\author{
Javier Rodríguez-Cuadrado
}
