% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/align.R
\name{align}
\alias{align}
\title{Inline alignment}
\usage{
align(x, vertical)
}
\arguments{
\item{x}{A tag element or \link{.style} pronoun.}

\item{vertical}{One of \code{"baseline"}, \code{"top"}, \code{"middle"}, \code{"bottom"}, \code{"text-top"}, or \code{"text-bottom"}.}
}
\description{
The \code{align()} function adjusts the inline alignment of an element.  This
applies only to inline elements and may be used to adjust the vertical
alignment of an image in a line of text or the contents of a table cell.

For broader alignment purposes use flex box, see \code{\link[=flex]{flex()}}.
}
\examples{

library(htmltools)

div(
  "Text",
  span("Above") \%>\% align("top"),
  span("Below") \%>\% align("bottom")
)

}
