% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.cartogramR.R
\name{summary.cartogramR}
\alias{summary.cartogramR}
\title{Summary of a cartogram object}
\usage{
\method{summary}{cartogramR}(object, ...)
}
\arguments{
\item{object}{a cartogramR object}

\item{\\dots}{arguments passed to or from other methods. The following
arguments are available:
- digits integer, used for number formatting with signif if
not specified (i.e., \verb{[missing](.)}, \verb{[signif]()} will not be
called anymore (since \\R >= 3.4.0, where the default has been
changed to only round in the \code{print} and \code{format} methods).
- quantile.type integer code used in \verb{quantile(*, type=quantile.type)}.
- center character string code used in \link{residuals.cartogramR}.}
}
\value{
A summary.cartogramR object: a list with the following components:
\itemize{
\item qrr, the summary of absolute relative residuals
\item qres, the summary of absolute residuals
\item qsymdiff, the summary of all pairwise symmetric difference beween two
scaled (multi)polygons representative of two regions.
}
}
\description{
Summary of a cartogram object
}
\examples{
\donttest{
  data(usa)
  carto <- cartogramR(usa, "electors64")
  summary(carto)
}

}
