% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psychant.R
\name{psychant}
\alias{psychant}
\title{Computes the psychometric antonym score}
\usage{
psychant(x, critval = -0.6, diag = FALSE)
}
\arguments{
\item{x}{is a matrix of item responses}

\item{critval}{is the minimum magnitude of the correlation between two items
in order for them to be considered psychometric synonyms. Defaults to -.60}

\item{diag}{additionally return the number of item pairs available for each subject. Useful if dataset contains many missing values.}
}
\description{
A convenient wrapper that calls \code{psychsyn} with argument \code{anto = TRUE} to compute the psychometric antonym score.
}
\examples{
antonyms <- psychant(careless_dataset2, .50)
antonyms <- psychant(careless_dataset2, .50, diag = TRUE)
}
\seealso{
\code{\link{psychsyn}} for the main function, \code{\link{psychsyn_critval}} for a helper that allows to set an
adequate critical value for the size of the correlation.
}
\author{
Richard Yentes \email{ryentes@gmail.com}, Francisco Wilhelm \email{franciscowilhelm@gmail.com}
}
