% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_c4c_base_result.R
\name{plot.c4c_base_result}
\alias{plot.c4c_base_result}
\title{Plot Function for c4c_base_result Objects}
\usage{
\method{plot}{c4c_base_result}(
  x,
  variable = c("area", "vol_standing", "vol_inc_ups", "vol_rmv_total", "vol_rmv_cont",
    "vol_rmv_damage", "vol_mort", "hrvst_det_reg", "hrvst_det_dam"),
  ...
)
}
\arguments{
\item{x}{Object of class \code{c4c_base_result}}

\item{variable}{Character string, specifies the variable to be plotted. The
options are:
\itemize{
\item{"area": The areas covered by the different stand development
phases (SDPH) over time}
\item{"vol_standing": The standing volume by SDPH over time}
\item{"vol_inc_ups": The volume increment by SDPH (upscaled from the
concept definition) over time}
\item{"vol_rmv_total": The total removed volume (comprising regular and
damage-induced harvest) by SDPH over time}
\item{"vol_rmv_cont": The volume removed due to regular harvest by SDPH
over time}
\item{"vol_rmv_damage": The volume removed due to damage-induced
harvest by SDPH over time}
\item{"vol_mort": The volume losses due to mortality by SDPH over time}
\item{"hrvst_det_reg": The regular harvest volume over time by tree
size classes (mean harvest diameter)}
\item{"hrvst_det_dam": The damage-induced harvest volume over time by
tree size classes (mean harvest diameter)}
}}

\item{...}{Other parameters, currently not used}
}
\value{
A ggplot object
}
\description{
Plot Function for c4c_base_result Objects
}
\examples{

  sim_base_out <- simulate_single_concept(
    pine_thinning_from_above_1,
    init_areas = c(1000, 0, 0, 0, 0, 0),
    time_span  = 200,
    risk_level = 3
  )

  # Make a plot
  plot(sim_base_out, variable = "area")
  # Also try the following options for the parameter "variable":
  # "vol_standing", "vol_inc_ups", "vol_rmv_total", "vol_rmv_cont",
  # "vol_rmv_damage", "vol_mort", "hrvst_det_reg", "hrvst_det_dam"

}
