% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/growth_and_yield_evaluation.R
\name{growth_and_yield_evaluation}
\alias{growth_and_yield_evaluation}
\title{Extensive Growth and Yield Evaluation}
\usage{
growth_and_yield_evaluation(sim_agg, concept_def, detailed_out = FALSE)
}
\arguments{
\item{sim_agg}{Aggregated simulated area dynamics, more precisely, the output
of \code{\link{aggregate_raw_sim_rslt}}}

\item{concept_def}{Concept definition matching \code{sim_agg}, a
\code{c4c_concept} object}

\item{detailed_out}{Boolean, if TRUE, also pre-evaluation output (calculated
by the internal function growth_and_yield_pre_eval) will be part of the
result list (default = FALSE)}
}
\value{
A list with two elements (see also details),
\itemize{
\item{\emph{gyield_summary}: A tibble that contains phase overarching growth
and yield information.}
\item{\emph{gyield_phases}: A list of tibbles, each one representing one of the
growth and yield variables also found in gyield_summary, but here on the
level of the single stand development phases.}
}
If the user has selected \code{detailed_out = TRUE}, there will also be
another list element, \emph{gyield_pre}, which contains the interim information
from which gyield_summary and gyield_phases are calculated.
}
\description{
Provide an extensive compilation of growth and yield related results.
}
\details{
The result object, a list, contains the following elements:
\itemize{
\item{\emph{gyield_summary}: A tibble that contains phase overarching growth
and yield information. In this tibble, each row is a point in time. The
columns (in addition to time) are: \emph{vol_standing}, the standing volume on
the total area of interest; \emph{vol_rmv_cont},the continuous removals that
take place, as long as an area is in a given phase; \emph{vol_rmv_trans}, the
volume removals occurring at phase transitions from phases with more to
such with less standing volume; \emph{vol_rmv_damage}, the volume losses due
to damage events; \emph{vol_rmv_harvest}, regular harvest volume, the sum of
vol_rmv_cont and vol_rmv_trans; \emph{vol_rmv_total}, all removed volume, the
sum of vol_rmv_harvest and vol_rmv_damage; \emph{vol_mort}, the mortality
volume (normal, not event-triggered); \emph{vol_inc}, the volume increment on
the whole area resulting from the vol_standing, vol_rmv_total,
and vol_mort.}
\item{\emph{gyield_phases}: A list of tibbles, one for each variable as
contained in gyield_summary (except the volume increment) which makes no
sense in a phase-wise context), but in phase-wise resolution. In each
tibble, each row is a point in time, the columns represent the stand
development phases.}
\item{\emph{gyield_pre} (in case the user has chosen
\code{detailed_out = TRUE}): A tibble, where each row is a point in
time. The columns (in addition to time) are: \emph{vol_standing}, the standing
volume on the total area of interest; \emph{vol_rmv_cont},the continuous
removals that take place, as long as an area is in a given phase;
\emph{vol_rmv_trans}, the volume removals occurring at phase transitions from
phases with more to such with less standing volume;\emph{vol_rmv_damage}, the
volume losses due to damage events; \emph{vol_rmv_harvest}, regular harvest
volume, the sum of vol_rmv_cont and vol_rmv_trans; \emph{vol_rmv_total}, all
removed volume, the sum of vol_rmv_harvest and vol_rmv_damage;
\emph{vol_mort}, the mortality volume (normal, not event-triggered);
\emph{vol_inc}, the volume increment on the whole area resulting from the
vol_standing, vol_rmv_total, and vol_mort.}
}
}
\examples{
  # Run a simulation and store the aggregated outcome
  state_vars <- setup_statevars(
    pine_thinning_from_above_1, c(1000, 0, 0, 0, 0, 0)
  )
  time_span <- 200
  parms     <- setup_parms(pine_thinning_from_above_1)
  parms$risk_mat <- setup_risk_events(
    time_span, avg_event_strength = 1, parms$risk
  )

  sim_areas_agg <- sim_area_single_concept_with_risk(
    state_vars,
    parms       = parms,
    event_times = c(0:time_span),
    time_span   = time_span
  ) |>
    aggregate_raw_sim_rslt(pine_thinning_from_above_1)

  # Growth and yield evaluation
  growth_and_yield_evaluation(sim_areas_agg, pine_thinning_from_above_1)

}
