% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ard_survival_survfit.R
\name{.process_survfit_probs}
\alias{.process_survfit_probs}
\title{Process Survival Fit For Quantile Estimates}
\usage{
.process_survfit_probs(x, probs)
}
\arguments{
\item{x}{(\code{survfit} or \code{data.frame})\cr
an object of class \code{survfit} created with \code{\link[survival:survfit]{survival::survfit()}} or a data frame. See below for details.}

\item{probs}{(\code{numeric})\cr
a vector of probabilities with values in (0,1) specifying the survival quantiles to return.}
}
\value{
a \code{tibble}
}
\description{
Process Survival Fit For Quantile Estimates
}
\examples{
\dontshow{if (do.call(asNamespace("cardx")$is_pkg_installed, list(pkg = "survival"))) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
survival::survfit(survival::Surv(AVAL, CNSR) ~ TRTA, cards::ADTTE) |>
  cardx:::.process_survfit_probs(probs = c(0.25, 0.75))
\dontshow{\}) # examplesIf}
}
\keyword{internal}
