% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recurrent-events.R
\name{recur_survival_table}
\alias{recur_survival_table}
\title{Recurrent Survival Data Format}
\usage{
recur_survival_table(
  data,
  id,
  first,
  last,
  event.dates,
  model.type,
  death = NULL
)
}
\arguments{
\item{data}{A dataframe containing the subsequent parameters}

\item{id}{Column in dataframe that contains unique IDs for each row}

\item{first}{Column with left/enrollment dates}

\item{last}{Column with right/censoring time point, or last contact}

\item{event.dates}{Vector of columns that contain event dates}

\item{model.type}{Character/string = c("marginal", "pwptt", "pwpgt")}

\item{death}{Column created for if death is known (0 or 1), original
dataframe (e.g. can add column of zeroes PRN). Death defaults to null for
intermediate calculations otherwise.}
}
\value{
A data frame organized into a survival table format
}
\description{
Reformats recurrent event data (wide) into different models for
survival analysis, but can also be used for simple survival analysis tables
as well. Importantly, for large datasets, this function will show
significant slow-down since it uses an intuitive approach on defining the
datasets. Future iterations will create a vectorized approach that should
provide performance speed-ups.
\itemize{
\item For recurrent events, the final censoring event can include death, or can
be ignored if its not considered a failure event.
\item For simple survival analysis, death censoring should be left as NULL, and
the event (e.g. "date_of_death"), should be used as a single \code{event.dates}
parameter. The function will do the rest.
}
}
\details{
This function takes every data event date, and creates several types
of recurrent event tables. It orders the data chronologically for repeat
events. Currently does marginal and conditional A and B models. The large
}
\examples{
\donttest{
# Data
data("mims")

# Parameters
id <- "patid"
first <- "first_visit_date_bl"
last <- "ldka"
event.dates <- c("mi_date_1", "mi_date_2", "mi_date_3")
model.type <- "marginal"
death <- "DEATH_CV_YN"

# Run analysis
tbl <- recur_survival_table(
  mims, id, first, last, event.dates, model.type, death
)
}

}
