% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics_vcov.R
\name{vcov.feglm}
\alias{vcov.feglm}
\title{Covariance matrix for GLMs}
\usage{
\method{vcov}{feglm}(
  object,
  type = c("hessian", "outer.product", "sandwich", "clustered"),
  ...
)
}
\arguments{
\item{object}{an object of class \code{"feglm"}.}

\item{type}{the type of covariance estimate required. \code{"hessian"} refers
to the inverse of the negative expected hessian after convergence and is the
default option. \code{"outer.product"} is the outer-product-of-the-gradient
estimator. \code{"sandwich"} is the sandwich estimator (sometimes also
referred as robust estimator), and \code{"clustered"} computes a clustered
covariance matrix given some cluster variables.}

\item{...}{additional arguments.}
}
\value{
A named matrix of covariance estimates.

A named matrix of covariance estimates.
}
\description{
Covariance matrix for the estimator of the structural parameters
from objects returned by \code{\link{feglm}}. The covariance is computed
from the hessian, the scores, or a combination of both after convergence.
}
\examples{
# same as the example in feglm but extracting the covariance matrix
mod <- fepoisson(mpg ~ wt | cyl | am, mtcars)
round(vcov(mod, type = "clustered"), 5)

}
\references{
Cameron, C., J. Gelbach, and D. Miller (2011). "Robust Inference
With Multiway Clustering". Journal of Business & Economic Statistics 29(2).
}
\seealso{
\code{\link{feglm}}
}
