% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SummarySurvey.R
\name{SummarySurvey}
\alias{SummarySurvey}
\title{Summary statistics for sample surveys}
\usage{
SummarySurvey(design = NULL, variables = NULL, conf.level = 0.95,
  rnd = 3)
}
\arguments{
\item{design}{an output form \code{\link{DesignSurvey}} function.}

\item{variables}{\code{\link{character}} \code{\link{vector}} with the type of estimate for each variable contained in \code{design} (see details).}

\item{conf.level}{the confidence level required.}

\item{rnd}{the number of decimal places (round) or significant digits (signif) to be used. If \code{NA}, scientific notation is used.}
}
\value{
Matrix with survey summaries.
}
\description{
Wraps functions for summary statistics from survey package.
}
\details{
The length of \code{variables} must be equal to the length of \code{names(design$variables)} (see examples).
}
\examples{
data(city)
data(hh)
## Two-stage cluster design that included 65 PSU.
data(cluster_sample)
cluster_sample2 <- cluster_sample[complete.cases(cluster_sample), c(1:2, 8:10)]
design <- DesignSurvey(sample = cluster_sample2,
             psu.ssu = city[, c("track_id", "hh")],
             psu.col = "track_id", ssu.col = "hh_id", psu.2cd = 65,
             cal.col = "persons", cal.N = sum(hh$persons))
vars <- rep("total", 3)
cbind(names(design$variables), vars)
SummarySurvey(design = design, variables = vars)

## Systematic sampling
data(sys_sample)
sys_sample2 <- sys_sample[complete.cases(sys_sample), 7:9]
design <- DesignSurvey(sample = sys_sample2, N = sum(city$hh),
                       cal.col = "persons", cal.N = sum(hh$persons))
vars <- rep("total", 3)
cbind(names(design$variables), vars)
#SummarySurvey(design = design, variables = vars)

}
\references{
Lumley, T. (2011). Complex surveys: A guide to analysis using R (Vol. 565). Wiley.

\url{http://oswaldosantos.github.io/capm}
}
