% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_bars.R
\name{plot_bars}
\alias{plot_bars}
\title{Plot phenotypic effect for two markers as a bar plot}
\usage{
plot_bars(
  phenoV,
  marker1_vals,
  marker2_vals,
  pheno_name,
  marker1_label,
  marker2_label,
  ymin = NULL,
  ymax = NULL,
  error_bars,
  ref_centered
)
}
\arguments{
\item{phenoV}{A vector of trait values}

\item{marker1_vals}{A vector of genotype values 
for marker1}

\item{marker2_vals}{A vector of genotype values
for marker2.}

\item{pheno_name}{A string indicating the name of
the trait being plotted.}

\item{marker1_label}{A string indicating the name
of marker1}

\item{marker2_label}{A string indicating the name
of marker2}

\item{ymin}{A numeric value indicating the minimum 
y value for the plot. If NULL, it will be calculated
based on phenoV and error bars.}

\item{ymax}{A numeric value indicating the maximum
y value for the plot. If NULL, it will be calculated
based on phenoV and error bars.}

\item{error_bars}{A string indicating the type of error
bars to draw. Can be "sd" for standard deviation, "se"
for standard error, or "none".}

\item{ref_centered}{Whether to center the effects
on the reference genotype.}
}
\value{
None
}
\description{
This internal function is called by 
\code{\link{plot_effects}} to generate a 
bar plot showing mean trait values for all
combinations of genotypes for two markers.
This function also indicates the predicted
additive effects of the two markers with 
a dashed line, as well as the error of the
predicted additive effect with an orange box.
The true effect of the marker combination is
shown with a gray bar. 
The effects can centered on the reference
allele to better show relative effects of 
each allele and allele combination.
}
\keyword{internal}
