% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/canvasXpress.R
\name{canvasXpress.json}
\alias{canvasXpress.json}
\title{HTML Widget Creation using JSON input}
\usage{
canvasXpress.json(
  json,
  pretty = FALSE,
  digits = 4,
  width = 600,
  height = 400,
  destroy = FALSE
)
}
\arguments{
\item{json}{JSON string or object}

\item{pretty}{print tagged code (JSON/HTML) nicely - default = FALSE}

\item{digits}{display digits - default = 4}

\item{width}{plot width (valid CSS units) - default = 600px}

\item{height}{plot height (valid CSS units) - default = 400px}

\item{destroy}{used to indicate removal of a plot - default = FALSE}
}
\value{
htmlwidgets object
}
\description{
Custom HTML widget creation function based on widget YAML and JavaScript for
use in any html-compatible context using raw JSON input.  Validation of data
and configuration is deferred completely to the canvasXpress JavaScript library.
}
\details{
For the formatting of the JSON input object see

**Note:** this function is intended for use by advanced users who are experimenting
with or need to utilize the json-formatted input to canvasXpress and are comfortable
debugging chart issues in a browser (JavaScript) context instead of in R.
}
\section{More Information}{

\url{https://www.canvasxpress.org}
}

\examples{

my_json <- '{ "data": {"y": { "vars": ["Performance"],
                              "smps": ["January"],
                              "data": [[85]] }},
              "config": { "graphType": "Meter",
                          "meterType": "gauge" }}'

canvasXpress.json(my_json)

}
