% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cpr_make_pal.R
\name{cpr_make_pal}
\alias{cpr_make_pal}
\title{Make a palette of colors for plotting CANAPE results}
\usage{
cpr_make_pal(name, type)
}
\arguments{
\item{name}{Character vector of length 1; name of palette to select. Must be
one of 'mishler2014', 'canaper1', 'canaper2', 'canaper3', or 'canaper4'}

\item{type}{Character vector of length 1; type of palette to select. Must be
one of 'endem' (endemism) or 'signif' (\emph{p}-rank significance)}
}
\value{
Named character vector; color hex codes
}
\description{
Palettes can also be loaded by name directly (see "Other colors" below).
}
\details{
Palettes with the name 'mishler2014' correspond to colors used in Mishler et
al. 2014. This color scheme has been widely used to show CANAPE
results, but some colors may not be distinguishable to people with color
vision deficiency (CVD).

Palettes with the name 'canaper1' or 'canaper2' are based on the Okabe-Ito
palette (endemism; Okabe & Ito 2002) or RColorBrewer (significance) and
should be CVD-friendly.

Names of colors correspond to either endemism type or
\emph{p}-rank output by \code{\link[=cpr_classify_endem]{cpr_classify_endem()}} or \code{\link[=cpr_classify_signif]{cpr_classify_signif()}},
respectively. Not all names are all available for both types.
}
\examples{
cpr_make_pal("mishler2014", "endem")
cpr_make_pal("canaper1", "endem")
scales::show_col(cpr_make_pal("mishler2014", "endem"))
}
\references{
Mishler, B., Knerr, N., González-Orozco, C. et al.  (2014)
Phylogenetic measures of biodiversity and
neo- and paleo-endemism in Australian Acacia. Nat Commun, 5: 4473.
\doi{10.1038/ncomms5473}

Okabe, M., & Ito, K. (2002) Color
Universal Design (CUD) - How to make figures and presentations that are
friendly to Colorblind people. J*FLY Data
Depository for Drosophila Researchers. \url{https://jfly.uni-koeln.de/color/}
}
\seealso{
Other colors: 
\code{\link{cpr_endem_cols_2}},
\code{\link{cpr_endem_cols_3}},
\code{\link{cpr_endem_cols_4}},
\code{\link{cpr_endem_cols}},
\code{\link{cpr_signif_cols_2}},
\code{\link{cpr_signif_cols}},
\code{\link{mishler_endem_cols}},
\code{\link{mishler_signif_cols}}
}
\concept{colors}
