% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/communityModel.R
\name{fit,commOccu-method}
\alias{fit,commOccu-method}
\title{Fit a community (multi-species) occupancy model}
\usage{
\S4method{fit}{commOccu}(
  object,
  n.iter = 100,
  thin = 1,
  n.burnin = 0,
  n.adapt = 0,
  cores = 1,
  chains = 3,
  compile = TRUE,
  WAIC = FALSE,
  quiet = FALSE,
  ...
)
}
\arguments{
\item{object}{\code{commOccu} object}

\item{n.iter}{number of iterations to monitor}

\item{thin}{thinning interval for monitors}

\item{n.burnin}{burnin length}

\item{n.adapt}{Length of adaptive phase}

\item{cores}{number of cores to utilize}

\item{chains}{number of MCMC chains to run}

\item{compile}{logical. If Nimble model, compile model with \code{\link[nimble]{compileNimble}} before running model?}

\item{WAIC}{logical. Return WAIC (only Nimble models)}

\item{quiet}{if TRUE messages and progress bar will be suppressed}

\item{...}{additional arguments to pass to \code{\link[nimble]{runMCMC}} (only relevant for Nimble)}
}
\value{
A coda::mcmc.list
}
\description{
Convenience function for fitting community occupancy models (defined in a commOccu object) in JAGS or Nimble.
}
\details{
Models will be fit either in JAGS or Nimble, depending on the decision made in the \code{nimble} argument in \code{\link{communityModel}}.

For Nimble, compilation is strongly recommended for long model runs. Uncompiled models can run extremely slow. Compilation itself can take a while also, and requires that Rtools is available on the system.

It is a convenience function only which hides some of the configuration options. If you require more control over model fitting, you can run all steps individually. See vignette 5 for details.
}
