% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/guess-delims.R
\name{guess_delim}
\alias{guess_delim}
\title{Guess the delimiter of a text file}
\source{
\url{https://github.com/r-lib/vroom/blob/master/R/vroom.R#L248}
}
\usage{
guess_delim(file, delims = c(",", "\\t", "|", ";"), string = FALSE)
}
\arguments{
\item{file}{Either a path to a file or character string (with at least one
newline character).}

\item{delims}{The vector of single characters to guess from. Defaults to:
comma, tab, pipe, or semicolon.}

\item{string}{Should the file be treated as a string regardless of newline.}
}
\value{
The single character guessed as a delimiter.
}
\description{
Taken from code used in \href{https://github.com/r-lib/vroom/blob/master/R/vroom.R#L248}{vroom::vroom()} with automatic reading.
}
\examples{
guess_delim(system.file("extdata", "vt_contribs.csv", package = "campfin"))
guess_delim("ID;FirstName;MI;LastName;JobTitle", string = TRUE)
guess_delim("
a|b|c
1|2|3
")
}
