% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/counters.R
\name{na_in}
\alias{na_in}
\title{Remove in}
\usage{
na_in(x, y, ignore.case = FALSE)
}
\arguments{
\item{x}{A vector to check.}

\item{y}{A vector to compare against.}

\item{ignore.case}{logical; if \code{FALSE}, the pattern matching is case
sensitive and if \code{TRUE}, case is ignored during matching.}
}
\value{
The vector \code{x} missing any values in \code{y}.
}
\description{
Set \code{NA} for the values of \code{x} that are \code{\%in\%} the vector \code{y}.
}
\examples{
na_in(c("VT", "NH", "ZZ", "ME"), state.abb)
na_in(1:10, seq(1, 10, 2))
}
\seealso{
Other counting wrappers: 
\code{\link{count_diff}()},
\code{\link{count_in}()},
\code{\link{count_na}()},
\code{\link{count_out}()},
\code{\link{count_vec}()},
\code{\link{na_out}()},
\code{\link{na_rep}()},
\code{\link{prop_distinct}()},
\code{\link{prop_in}()},
\code{\link{prop_na}()},
\code{\link{prop_out}()},
\code{\link{which_in}()},
\code{\link{which_out}()}
}
\concept{counting wrappers}
