% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normal-phone.R
\name{normal_phone}
\alias{normal_phone}
\title{Normalize phone number}
\usage{
normal_phone(
  number,
  format = "(\%a) \%e-\%l",
  na_bad = FALSE,
  convert = FALSE,
  rm_ext = FALSE
)
}
\arguments{
\item{number}{A vector of phone number in any format.}

\item{format}{The desired output format, with \verb{\%a} representing the 3-digit
\strong{area} code, \verb{\%e} representing the 3-digit \strong{exchange}, and \verb{\%l}
representing the 4-digit \strong{line} number. The punctuation between each part
of the format is used in the normalized number (e.g., \code{"(\%a) \%e-\%l"} or
\code{"\%a-\%e-\%l"}).}

\item{na_bad}{logical; Should invalid numbers be replaced with \code{NA}.}

\item{convert}{logical; Should \code{\link[=keypad_convert]{keypad_convert()}} be invoked to replace
numbers with their keypad equivalent.}

\item{rm_ext}{logical; Should extensions be removed from the end of a number.}
}
\value{
A normalized telephone number.
}
\description{
Take US phone numbers in any number of formats and try to convert them to a
standard format.
}
\examples{
normal_phone(number = c("916-225-5887"))
}
