% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_experiment.R
\name{run_experiment}
\alias{run_experiment}
\title{Run experiment}
\usage{
run_experiment(x, outputs = NULL, parse = TRUE, aggregate = TRUE, ...)
}
\arguments{
\item{x}{A \linkS4class{CalmrExperiment} or design \code{data.frame}}

\item{outputs}{A character vector specifying which outputs to
parse and aggregate. Defaults to NULL, in which case
all model outputs are parsed/aggregated.}

\item{parse}{A logical specifying whether the raw results
should be parsed. Default = TRUE.}

\item{aggregate}{A logical specifying whether the parsed results
should be aggregated. Default = TRUE.}

\item{...}{Arguments passed to other functions}
}
\value{
A \linkS4class{CalmrExperiment} with results.
}
\description{
Runs an experiment with minimal parameters.
}
\examples{
# Using a data.frame only (throws warning)
df <- get_design("relative_validity")
run_experiment(df, model = "RW1972")

# Using custom parameters
df <- get_design("relative_validity")
pars <- get_parameters(df, model = "HD2022")
pars$alphas["US"] <- 0.6
run_experiment(df, parameters = pars, model = "HD2022")

# Using make_experiment, for more iterations
df <- get_design("blocking")
pars <- get_parameters(df, model = "SM2007")
exper <- make_experiment(df,
  parameters = pars, model = "SM2007",
  iterations = 4
)
run_experiment(exper)

# Only parsing the associations in the model, without aggregation
run_experiment(exper, outputs = "vs", aggregate = FALSE)
}
