% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_fire_danger_levels.R
\name{get_fire_danger_levels}
\alias{get_fire_danger_levels}
\title{get_fire_danger_levels}
\usage{
get_fire_danger_levels(fire_index, ndays = 4)
}
\arguments{
\item{fire_index}{RasterBrick containing the fire index to calculate the
thresholds for. Please note that names(fire_index) should contain dates.}

\item{ndays}{Number of days per year in which a fire is expected to occur.
By default this is 4 days.}
}
\value{
A numeric vector listing the thresholds.
}
\description{
This function calculates the danger levels
(VeryLow-Low-Moderate-High-VeryHigh-Extreme) for a given country.
}
\examples{
\dontrun{

  # Generate dummy brick
  set.seed(0)
  r <- raster(nrows = 2, ncols = 2,
              xmn = 0, xmx = 360, ymn = -90, ymx = 90, vals = 30)
  # Simulate a long reanalysis record
  b <- raster::brick(lapply(1:(365 * 3),
       function(i) raster::setValues(r, runif(n = raster::ncell(r),
                                              min = 0, max = 100))))
  names(b) <- seq.Date(from = as.Date("1993-01-01"),
                       to = as.Date("1995-12-31"),
                       by = "day")
  # Generate danger levels
  get_fire_danger_levels(fire_index = b)

}

}
