% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mxdet.R
\name{mxdet}
\alias{mxdet}
\title{Numerical and Symbolic Determinant}
\usage{
mxdet(x)
}
\arguments{
\item{x}{\code{numeric} or \code{character} matrix.}
}
\value{
\code{numeric} or \code{character}.
}
\description{
Computes the determinant of a \code{numeric} or \code{character} matrix.
}
\examples{
### numeric matrix
x <- matrix(1:4, nrow = 2)
mxdet(x)

### symbolic matrix
x <- matrix(letters[1:4], nrow = 2)
mxdet(x)

}
\references{
Guidotti, E. (2020). "calculus: High dimensional numerical and symbolic calculus in R". \url{https://arxiv.org/abs/2101.00086}
}
\seealso{
Other matrix algebra: 
\code{\link{mxinv}()},
\code{\link{mxtr}()},
\code{\link{mx}()}
}
\concept{matrix algebra}
